<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;
$id_blog = isset($_GET['id_blog']) ? $_GET['id_blog'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id, $id_blog);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo);
        break;

    case 'DELETE':
        handleDELETE($pdo);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id, $id_blog) {
  try {
      if ($id) {
          $stmt = $pdo->prepare("SELECT * FROM blogs WHERE slug = :id");
          $stmt->bindParam(':id', $id, PDO::PARAM_STR);
          $stmt->execute();
          $data = $stmt->fetch(PDO::FETCH_ASSOC);
          $data = array_map('convertBooleans', [$data]);

          if ($data) {
            echo json_encode(['blog' => $data]);

          } else {
              http_response_code(404);
              echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
          }
      } else if ($id_blog) {
            // Obtener un solo registro
            $stmt = $pdo->prepare("SELECT * FROM blogs WHERE id = :id");
            $stmt->bindParam(':id', $id_blog, PDO::PARAM_STR);
            $stmt->execute();
            $data = $stmt->fetch(PDO::FETCH_ASSOC);
            $data = array_map('convertBooleans', [$data]);

            if ($data) {
            echo json_encode(['blog' => $data]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
            }
        } else {
          // Obtener todos los registros
          $stmt = $pdo->prepare("SELECT 
          img_destacada,fechaRegistro, categorias, titulo, destacado, slug, img_thumb, img_contenido, path_img_thumb, descripcion_breve, activo, likes, edad, restringido, path_img_destacada, path_img_contenido, 
          descripcion, titulo_detalle, portada,favoritos, id 
          FROM blogs");
          $stmt->execute();
          $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
          $data = array_map('convertBooleans', $data);

          echo json_encode(['blogs' => $data]);

      }
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}

function handlePOST($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $incremento = $data['incremento'] ?? null;
    $tipo = $data['tipo'] ?? null;
    $id = $data['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Faltan parametros en la solicitud']);
        return;
    }

    try {
        if($incremento !== null){
            $query = $tipo === "likes"
            ? 'UPDATE blogs SET likes = ? WHERE id = ?'
            : 'UPDATE blogs SET favoritos = ? WHERE id = ?';

            $stmt = $pdo->prepare($query);
            $stmt->execute([$incremento, $id]);

            if ($stmt->rowCount() === 0) {
                http_response_code(404);
                echo json_encode(['message' => 'Registro no encontrado']);
                return;
            }
            echo json_encode(['message' => 'Valor incrementado con exito']);
        }
            else{
        
                $sql = "INSERT INTO blogs (
                    id,
                    fechaRegistro, 
                    categorias, 
                    img_destacada,
                    img_portada,
                    img_thumb, 
                    path_img_thumb, 
                    descripcion_breve,
                    img_contenido, 
                    slug,
                    destacado,
                    contenido,
                    edad,
                    likes,
                    path_img_destacada, 
                    activo, 
                    path_img_contenido,
                    descripcion,
                    restringido,
                    titulo_detalle,
                    portada,
                    favoritos,
                    titulo
                ) VALUES (
                    :id,
                    :fechaRegistro, 
                    :categorias, 
                    :img_destacada,
                    :img_portada, 
                    :img_thumb, 
                    :path_img_thumb, 
                    :descripcion_breve, 
                    :img_contenido, 
                    :slug, 
                    :destacado, 
                    :contenido,
                    :edad,
                    :likes,
                    :path_img_destacada, 
                    :activo, 
                    :path_img_contenido, 
                    :descripcion,
                    :restringido,
                    :titulo_detalle,
                    :portada,
                    :favoritos,
                    :titulo
                )";
        
                // Preparar la consulta
                $stmt = $pdo->prepare($sql);
        
                $stmt->execute([
                    ':id' => $id,
                    ':fechaRegistro' => $data['fechaRegistro'],
                    ':categorias' => $data['categorias'],
                    ':img_destacada' => $data['img_destacada'],
                    ':img_portada' => $data['img_portada'],
                    ':img_thumb' => $data['img_thumb'],
                    ':path_img_thumb' => $data['path_img_thumb'],
                    ':descripcion_breve' => $data['descripcion_breve'],
                    ':img_contenido' => $data['img_contenido'],
                    ':slug' => $data['slug'],
                    ':destacado' => $data['destacado'],
                    ':contenido' => $data['contenido'],
                    ':activo' => $data['activo'],
                    ':edad' => $data['edad'],
                    ':likes' => $data['likes'],
                    ':restringido' => $data['restringido'],

                    ':path_img_destacada' => $data['path_img_destacada'],
                    ':path_img_contenido' => $data['path_img_contenido'],
                    ':descripcion' => $data['descripcion'],
                    ':titulo_detalle' => $data['titulo_detalle'],
                    ':portada' => $data['portada'],
                    ':favoritos' => $data['favoritos'],
                    ':titulo' => $data['titulo'],
                 ]);
        
                // Retornar un mensaje de éxito
                echo json_encode(['id' => $pdo-> $data['id']]);
        }
    
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor']);
    }
}

function handlePUT($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    try {
        if ($id) {
            // Si se pasa un ID, realizar actualización
            $sql = "UPDATE blogs SET
                fechaRegistro = :fechaRegistro,
                categorias = :categorias,
                img_destacada=:img_destacada,
                img_portada=:img_portada,
                descripcion_breve = :descripcion_breve,
                img_thumb = :img_thumb,
                path_img_thumb = :path_img_thumb,
                img_contenido =:img_contenido,
                slug = :slug,
                destacado = :destacado,
                contenido =:contenido,
                activo = :activo,
                edad = :edad,
                likes =:likes,
                restringido = :restringido,
                path_img_destacada =:path_img_destacada,
                path_img_contenido= :path_img_contenido,
                descripcion =:descripcion,
                titulo_detalle =:titulo_detalle,
                portada = :portada,
                favoritos = :favoritos,
                titulo = :titulo
            WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':fechaRegistro' => $data['fechaRegistro'],
            ':categorias' => $data['categorias'],
            ':img_destacada' => $data['img_destacada'],
            ':img_portada' => $data['img_portada'],
            ':img_thumb' => $data['img_thumb'],
            ':path_img_thumb' => $data['path_img_thumb'],
            ':descripcion_breve' => $data['descripcion_breve'],
            ':img_contenido' => $data['img_contenido'],
            ':slug' => $data['slug'],
            ':destacado' => $data['destacado'],
            ':contenido' => $data['contenido'],
            ':activo' => $data['activo'],
            ':edad' => $data['edad'],
            ':likes' => $data['likes'],
            ':restringido' => $data['restringido'],

            ':path_img_destacada' => $data['path_img_destacada'],
            ':path_img_contenido' => $data['path_img_contenido'],
            ':descripcion' => $data['descripcion'],
            ':titulo_detalle' => $data['titulo_detalle'],
            ':portada' => $data['portada'],
            ':favoritos' => $data['favoritos'],
            ':titulo' => $data['titulo'],
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => $id ? 'Actualizado con exito' : 'Insertado con exito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'No se encontro el registro para actualizar']);
        }

        
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor']);
    }
}

function handleDELETE($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;
    $activo = false;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Se requiere un ID para eliminar el registro']);
        return;
    }

    try {
        if ($id) {
            $sql = "UPDATE blogs SET
                activo = :activo
            WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':activo' => $activo,
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => 'Eliminado con exito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'No se encontro el registro para actualizar']);
        }
    }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor: ' . $e->getMessage()]);
    }
}

function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}

?>
