<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

$id = isset($_GET['id']) ? $_GET['id'] : null;
$sku = isset($_GET['sku']) ? $_GET['sku'] : null;
$method = $_SERVER['REQUEST_METHOD'];

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGet($pdo, $id, $sku);
        break;
    
    case 'POST':
        handlePost($pdo);
        break;
    
    case 'PUT':
        handlePut($pdo);
        break;
    
    case 'DELETE':
        handleDelete($pdo);
        break;
    
    default:
        http_response_code(405);
        echo json_encode(['error' => 'Método no permitido']);
        break;
}

// Función para manejar GET
function handleGet($pdo, $id, $sku) {
    try {
        if ($id) {
            // Obtener un solo registro
            $stmt = $pdo->prepare("SELECT * FROM descargable WHERE id = :id");
            $stmt->bindParam(':id', $id, PDO::PARAM_STR);
            $stmt->execute();   
            $data = $stmt->fetch(PDO::FETCH_ASSOC);
            $descargables = array_map('convertBooleans', [$data]);
  
            if ($data) {
              echo json_encode([
                  'descargable' => $descargables,
              ]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
            }
        } else if ($sku) {
            // Obtener un solo registro por sku
            $stmt = $pdo->prepare("SELECT * FROM descargable WHERE sku = :sku");
            $stmt->bindParam(':sku', $sku, PDO::PARAM_STR);
            $stmt->execute();   
            $data = $stmt->fetch(PDO::FETCH_ASSOC);
            $descargable = array_map('convertBooleans', [$data]);

            if ($data) {
                echo json_encode([
                    'descargable' => $descargable,
                ]);
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
            }
        }  else{
            $stmt = $pdo->query('SELECT * FROM descargable');
        
            $descargables = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $descargables = array_map('convertBooleans', $descargables);
            
            echo json_encode(['descargables' => $descargables]);}
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error al obtener los datos']);
    }
}

// Función para manejar POST
function handlePost($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $incremento = $data['incremento'] ?? null;
    $tipo = $data['tipo'] ?? null;
    $id = $data['id'] ?? null;

    try {
       if($incremento !== null){
            $query = $tipo === "timesDownloaded"
            ? 'UPDATE descargable SET descargados = ? WHERE id = ?'
            : 'UPDATE descargable SET favoritos = ? WHERE id = ?';

            $stmt = $pdo->prepare($query);
            $stmt->execute([$incremento, $id]);

            if ($stmt->rowCount() === 0) {
                http_response_code(404);
                echo json_encode(['message' => 'Registro no encontrado']);
                return;
            }

            echo json_encode(['message' => 'Valor incrementado con exito']);
       }
       else{
        
           $sql = "INSERT INTO descargable (
               id,
               fechaRegistro, 
               categorias, 
               titulo, 
               img_thumb, 
               path_img_thumb, 
               descripcion_breve, 
               edad, 
               descargar_pdf, 
               activo, 
               path_descargar_pdf, 
               contenido, 
               upload_pdf,
               restringido,
               sku,
               destacado
           ) VALUES (
               :id,
               :fechaRegistro, 
               :categorias, 
               :titulo, 
               :img_thumb, 
               :path_img_thumb, 
               :descripcion_breve, 
               :edad, 
               :descargar_pdf, 
               :activo, 
               :path_descargar_pdf, 
               :contenido, 
               :upload_pdf,
               :restringido,
               :sku,
               :destacado
           )";
   
           // Preparar la consulta
           $stmt = $pdo->prepare($sql);
   
           $stmt->execute([
                ':id' => $data['id'],
                ':fechaRegistro' => $data['fechaRegistro'],
                ':categorias' => $data['categorias'],
                ':titulo' => $data['titulo'],
                ':img_thumb' => $data['img_thumb'],
                ':path_img_thumb' => $data['path_img_thumb'],
                ':descripcion_breve' => $data['descripcion_breve'],
                ':edad' => $data['edad'],
                ':descargar_pdf' => $data['descargar_pdf'],
                ':activo' => $data['activo'],
                ':path_descargar_pdf' => $data['path_descargar_pdf'],
                ':contenido' => $data['contenido'],
                ':upload_pdf' => $data['upload_pdf'],
                ':restringido' => $data['restringido'],
                ':sku' => $data['sku'],
                ':destacado' => $data['destacado']
            ]);
   
           // Retornar un mensaje de éxito
           echo json_encode(['id' => $pdo-> $data['id']]);
       }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor']);
    }
}



// Funcion para manejar PUT
function handlePut($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    try {
        if ($id) {
            // Si se pasa un ID, realizar actualización
            $sql = "UPDATE descargable SET
                fechaRegistro = :fechaRegistro,
                categorias = :categorias,
                titulo = :titulo,
                img_thumb = :img_thumb,
                path_img_thumb = :path_img_thumb,
                descripcion_breve = :descripcion_breve,
                edad = :edad,
                descargar_pdf = :descargar_pdf,
                activo = :activo,
                path_descargar_pdf = :path_descargar_pdf,
                contenido = :contenido,
                upload_pdf = :upload_pdf,
                restringido = :restringido,
                sku = :sku,
                destacado = :destacado
            WHERE id = :id";
        
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':fechaRegistro' => $data['fechaRegistro'],
            ':categorias' => $data['categorias'],
            ':titulo' => $data['titulo'],
            ':img_thumb' => $data['img_thumb'],
            ':path_img_thumb' => $data['path_img_thumb'],
            ':descripcion_breve' => $data['descripcion_breve'],
            ':edad' => $data['edad'],
            ':descargar_pdf' => $data['descargar_pdf'],
            ':activo' => $data['activo'],
            ':path_descargar_pdf' => $data['path_descargar_pdf'],
            ':contenido' => $data['contenido'],
            ':upload_pdf' => $data['upload_pdf'],
            ':restringido' => $data['restringido'],
            ':sku' => $data['sku'],
            ':destacado' => $data['destacado']
        ]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['id' => $id, 'message' => $id ? 'Actualizado con exito' : 'Insertado con exito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'No se encontro el registro para actualizar']);
        }

        
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor']);
    }
}

// Funcion para manejar DELETE
function handleDelete($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;
    $delete = $data['delete'] ?? false;
    $activo = false;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Se requiere un ID para eliminar el registro']);
        return;
    }

    try {
        if($delete){
            $sql = "DELETE FROM descargable WHERE id = :id";
            $stmt = $pdo->prepare($sql);
    
            $stmt->execute([':id' => $id]);
            if ($stmt->rowCount() > 0) {
                echo json_encode(['id' => $id, 'message' => 'Eliminado con exito']);
            } else {
                http_response_code(404);
                echo json_encode(['message' => 'No se encontro el registro para actualizar']);
            }
        }
        else if ($id) {
            $sql = "UPDATE descargable SET
                activo = :activo
            WHERE id = :id";
        
            $stmt = $pdo->prepare($sql);

            $stmt->execute([
                ':id' => $id,
                ':activo' => $activo,
            ]);

            if ($stmt->rowCount() > 0) {
                echo json_encode(['id' => $id, 'message' => 'Eliminado con exito']);
            } else {
                http_response_code(404);
                echo json_encode(['message' => 'No se encontro el registro para actualizar']);
            }
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor: ' . $e->getMessage()]);
    }
}


function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}
?>
