<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo, $id);
        break;

    case 'DELETE':
        handleDELETE($pdo, $id);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id) {
  try {
      if ($id) {
          // Obtener un solo registro
          $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = :email");
          $stmt->bindParam(':email', $id, PDO::PARAM_STR);
          $stmt->execute();
          $data = $stmt->fetch(PDO::FETCH_ASSOC);
          $data = array_map('convertBooleans', [$data]);

          if ($data) {
            echo json_encode(['usuarios' => $data]);
          } else {
              http_response_code(404);
              echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
          }
      } 
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}


function handlePOST($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $email = filter_var($input['email'] ?? null, FILTER_VALIDATE_EMAIL);
    $password = $input['password'] ?? null;
    $tipo = $input['tipo'] ?? null;

    try {
        if ($tipo === "actualizar") {
            if (!$password && !$email) {
                http_response_code(401);
                echo json_encode(['error' => 'Error Datos']);
                return;
            }
            
            $stmt = $pdo->prepare('UPDATE usuarios SET password = ? WHERE email = ?');
            $stmt->execute([$password, $email]);

            if ($stmt->rowCount() === 0) {
                http_response_code(404);
                echo json_encode(['message' => 'Registro no encontrado']);
                return;
            }

            echo json_encode(['message' => 'update']);
            return;
        } else {
            $stmt = $pdo->prepare('SELECT * FROM usuarios WHERE email = ?');
            $stmt->execute([$email]);
            $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$usuario) {
                http_response_code(401);
                echo json_encode(['error' => 'Invalido email o password']);
                return;
            }

            if (!$usuario['password']) {
                http_response_code(401);
                echo json_encode(['error' => 'No registrado']);
                return;
            }

            if ($password !== $usuario['password']) {
                http_response_code(401);
                echo json_encode(['error' => "Contraseña incorrecta"]);
                return;
            }

            // Actualizar el campo ultimoAcceso con la fecha actual en formato dd/mm/aaaa
            $fechaActual = date('d/m/Y');
            $stmt_update = $pdo->prepare('UPDATE usuarios SET ultimoAcceso = ? WHERE email = ?');
            $stmt_update->execute([$fechaActual, $email]);

            $stmt_descargables = $pdo->prepare('SELECT * FROM usuarios_descargables WHERE id_usuario = ?');
            $stmt_descargables->execute([$usuario["id"]]);
            $descargables = $stmt_descargables->fetchAll(PDO::FETCH_ASSOC);

            $stmt_videos = $pdo->prepare('SELECT * FROM usuarios_videos WHERE id_usuario = ?');
            $stmt_videos->execute([$usuario["id"]]);
            $videos = $stmt_videos->fetchAll(PDO::FETCH_ASSOC);

            $stmt_blogs = $pdo->prepare('SELECT * FROM usuarios_blogs WHERE id_usuario = ?');
            $stmt_blogs->execute([$usuario["id"]]);
            $blogs = $stmt_blogs->fetchAll(PDO::FETCH_ASSOC); 

            echo json_encode([
                'usuario' => $usuario,
                'blogs' => $blogs,
                'videos' => $videos,
                'descargables' => $descargables,
            ]);
            return;
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to fetch data']);
    }
}

function handlePUT($pdo, $id) {
    if (!$id) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "ID no proporcionado"]);
        return;
    }

    $input = json_decode(file_get_contents('php://input'), true);

    $activo = $input['activo'];
    $descripcion_breve = $input['descripcion_breve'];
    $fechaRegistro = $input['fechaRegistro'];
    $img_background = $input['img_background'];
    $path_img_background = $input['path_img_background'];
    $titulo = $input['titulo'];


    try {
        $stmt = $pdo->prepare("UPDATE productos SET 
        activo = :activo, descripcion_breve = :descripcion_breve, fechaRegistro = :fechaRegistro, 
        img_background = :img_background, path_img_background = :path_img_background, titulo = :titulo  
        WHERE id = :id");
        
        $stmt->bindParam(':activo', $activo);
        $stmt->bindParam(':descripcion_breve', $descripcion_breve);
        $stmt->bindParam(':fechaRegistro', $fechaRegistro);
        $stmt->bindParam(':img_background', $img_background);
        $stmt->bindParam(':path_img_background', $path_img_background);
        $stmt->bindParam(':titulo', $titulo);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        if ($stmt->rowCount()) {
            echo json_encode(["status" => "success", "message" => "Registro actualizado correctamente"]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado o sin cambios"]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}

function handleDELETE($pdo, $id) {
    if (!$id) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "ID no proporcionado"]);
        return;
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM productos WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();

        if ($stmt->rowCount()) {
            echo json_encode(["status" => "success", "message" => "Registro eliminado correctamente"]);
        } else {
            http_response_code(404);
            echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al eliminar el registro: " . $e->getMessage()]);
    }
}

function encrypt($string, $shift) {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $result .= chr(ord($string[$i]) + $shift);
    }
    return $result;
}

function decrypt($string, $shift) {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $result .= chr(ord($string[$i]) - $shift);
    }
    return $result;
}


function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}
?>
