<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");


// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo, $id);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo, $id);
        break;

    case 'DELETE':
        handleDELETE($pdo, $id);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handleGET($pdo, $id) {
  try {
      if ($id) {
          // Obtener un solo registro
          $stmt = $pdo->prepare("SELECT * FROM productos WHERE id = :id");
          $stmt->bindParam(':id', $id, PDO::PARAM_STR);
          $stmt->execute();
          $data = $stmt->fetch(PDO::FETCH_ASSOC);

          $stmt_galeria = $pdo->query('SELECT * FROM galeria_productos');
          $galeria = $stmt_galeria->fetchAll(PDO::FETCH_ASSOC);

          if ($data) {
            echo json_encode([
                'productos' => $data,
                'galeria' => $galeria
            ]);
          } else {
              http_response_code(404);
              echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
          }
      } else {

        $stmt_productos = $pdo->query('SELECT * FROM productos');
        $productos = $stmt_productos->fetchAll(PDO::FETCH_ASSOC);

        // Consultar la tabla galeria_productos
        $stmt_galeria = $pdo->query('SELECT * FROM galeria_productos');
        $galeria = $stmt_galeria->fetchAll(PDO::FETCH_ASSOC);

        // Enviar la respuesta en formato JSON
        echo json_encode([
            'productos' => $productos,
            'galeria' => $galeria
        ]);
      }
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}

function handlePOST($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    try {
        $sql = "INSERT INTO productos (
            id,
            fechaRegistro, 
            titulo, 
            activo, 
            descripcion_breve, 
            path_img_background, 
            img_background
        ) VALUES (
            :id,
            :fechaRegistro, 
            :titulo, 
            :activo, 
            :descripcion_breve, 
            :path_img_background, 
            :img_background
        )";

        // Preparar la consulta
        $stmt = $pdo->prepare($sql);

        $stmt->execute([
            ':id' => $id,
            ':fechaRegistro' => $data['fechaRegistro'],
            ':titulo' => $data['titulo'],
            ':activo' => $data['activo'],
            ':descripcion_breve' => $data['descripcion_breve'],
            ':path_img_background' => $data['path_img_background'],
            ':img_background' => $data['img_background']
         ]);

         if (!empty($data['galeria'])) {
            foreach ($data['galeria'] as $galeria) {
                $sqlgaleria = "UPDATE galeria_productos SET
                    producto_id  = :producto_id,
                    path_imagen = :path_imagen,
                    fechaRegistro = :fechaRegistro,
                    imagen = :imagen,
                    orden = :orden
                WHERE id = :id";

                $stmtgaleria = $pdo->prepare($sqlgaleria);

                $stmtgaleria->execute([
                    ':id' => $galeria['id'],
                    ':producto_id' => $galeria['producto_id'],
                    ':imagen' => $galeria['imagen'],
                    ':path_imagen' => $galeria['path_imagen'],
                    ':fechaRegistro' => $galeria['fechaRegistro'],
                    ':imagen' => $galeria['imagen'],
                    ':orden' => $galeria['orden']
                ]);
            }
        }

        // Retornar un mensaje de éxito
        echo json_encode(['id' => $pdo-> $data['id']]);
        echo json_encode(["status" => "success", "message" => "Registro creado correctamente", "id" => $id]);
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al crear el registro: " . $e->getMessage()]);
    }
}

function handlePUT($pdo) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    try {
        if ($id) {
            // Si se pasa un ID, realizar actualización del producto
            $sql = "UPDATE productos SET
                fechaRegistro = :fechaRegistro,
                titulo = :titulo,
                activo = :activo,
                descripcion_breve = :descripcion_breve,
                path_img_background = :path_img_background,
                img_background = :img_background
            WHERE id = :id";
        
            $stmt = $pdo->prepare($sql);

            $stmt->execute([
                ':id' => $id,
                ':fechaRegistro' => $data['fechaRegistro'],
                ':titulo' => $data['titulo'],
                ':activo' => $data['activo'],
                ':descripcion_breve' => $data['descripcion_breve'],
                ':path_img_background' => $data['path_img_background'],
                ':img_background' => $data['img_background']
            ]);

            // Verificar si se realizó alguna actualización
            if ($stmt->rowCount() > 0) {
                $message = 'Producto actualizado con éxito';
            } else {
                $message = 'No se encontraron cambios en el producto';
            }
        }
        
        if (!empty($data['galeria'])) {
            // Como $data['galeria'] es un objeto de objetos, recorremos con foreach
            foreach ($data['galeria'] as $key => $galeria) {

                // Eliminar la imagen de la galería si `delete` es true
                if (!empty($galeria['delete'])) {
                    $sqlDelete = "DELETE FROM galeria_productos WHERE producto_id = :producto_id AND path_imagen = :path_imagen AND orden = :orden";
                    $stmtDelete = $pdo->prepare($sqlDelete);
                    $stmtDelete->execute([
                        ':producto_id' => $galeria['producto_id'],
                        ':path_imagen' => $galeria['path_imagen'],
                        ':orden' => $galeria['orden']
                    ]);
                } 
                
                // Insertar si no existe ID
                else {
                    $sqlInsert = "INSERT INTO galeria_productos 
                        (producto_id, path_imagen, fechaRegistro, imagen, orden) 
                        VALUES (:producto_id, :path_imagen, :fechaRegistro, :imagen, :orden)";
                    $stmtInsert = $pdo->prepare($sqlInsert);
                    $stmtInsert->execute([
                        ':producto_id' => $galeria['producto_id'],
                        ':path_imagen' => $galeria['path_imagen'],
                        ':fechaRegistro' => $galeria['fechaRegistro'],
                        ':imagen' => $galeria['imagen'],
                        ':orden' => $galeria['orden']
                    ]);
                }
            }
        }

        echo json_encode(['id' => $id, 'message' => $data['galeria']]);
    
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Error al actualizar el registro: " . $e->getMessage()]);
    }
}

function handleDELETE($pdo, $id) {
    $data = json_decode(file_get_contents('php://input'), true);
    $id = $data['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode(['error' => 'Se requiere un ID para eliminar el registro']);
        return;
    }

    try {
        // Preparar la consulta de eliminación
        $sql = "DELETE FROM productos WHERE id = :id";
        $stmt = $pdo->prepare($sql);

        // Ejecutar la consulta con el ID proporcionado
        $stmt->execute([':id' => $id]);

        if ($stmt->rowCount() > 0) {
            echo json_encode(['message' => 'Registro eliminado con éxito']);
        } else {
            http_response_code(404);
            echo json_encode(['message' => 'Registro no encontrado']);
        }
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error en el servidor: ' . $e->getMessage()]);
    }
}
?>
