<?php

include '../conection/database.php';

$database = new Database();
$db = $database->getConnection();
// Lee el ID del producto a eliminar desde la solicitud
$input = json_decode(file_get_contents("php://input"), true);
$producto_id = $input['id'] ?? null;

// Valida que el ID esté presente
if (!$producto_id) {
    http_response_code(400);
    echo json_encode(["message" => "ID del producto no proporcionado"]);
    exit;
}

try {
    // Elimina el registro en la base de datos
    $deleteQuery = $db->prepare("DELETE FROM productos_catalogo WHERE id = :id");
    $deleteQuery->bindParam(":id", $producto_id, PDO::PARAM_INT);

    if ($deleteQuery->execute()) {
        echo json_encode(["message" => "Producto eliminado correctamente"]);
    } else {
        throw new Exception("Error al eliminar el producto de la base de datos");
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["message" => $e->getMessage()]);
}
