<?php

include '../conection/database.php';

$database = new Database();
$db = $database->getConnection();
$id = isset($_POST['id']) ? $_POST['id'] : null;

try {
    // Verificar y conectar a la base de datos
    global $db; // Asegúrate de que $db esté correctamente inicializado.

    // Recibir los datos del formulario
    $activo = $_POST['activo'] ?? 1;
    $nombre = $_POST['nombre'] ?? null;
    $descripcion = $_POST['descripcion'] ?? null;
    $categoria = $_POST['categoria'] ?? null;
    $sku = $_POST['sku'] ?? null;
    $link_amazon = $_POST['link_amazon'] ?? null;
    $link_ml = $_POST['link_ml'] ?? null;
    $descripcion_complementaria = $_POST['descripcion_complementaria'] ?? null;
    $titulo_complementario = $_POST['titulo_complementario'] ?? null;
    $meta_tags = $_POST['meta_tags'] ?? null;
    $imagenesEliminadas = isset($_POST['productos_imagenes_eliminadas']) ? json_decode($_POST['productos_imagenes_eliminadas'], true) : [];
    $imagenesPequenasEliminadas = isset($_POST['productos_imagenes_pequenas_eliminadas']) ? json_decode($_POST['productos_imagenes_pequenas_eliminadas'], true) : [];
    $idDescargable = $_POST['idDescargable'] ?? null;
    $labelDescargable = $_POST['labelDescargable'] ?? null;
    $descargableCategoria = $_POST['descargableCategoria'] ?? null;
    $video = $_POST['video'] ?? null;
    
    // Manejo de archivos para la imagen complementaria e infografía
    $imagen_complementariaPath = handleFileUpload('imagen_complementaria', 'ProductosCatalogo/', 'complementaria_');
    $imagen_principalPath = handleFileUpload('imagen_principal', 'ProductosCatalogo/', 'principal_');
    $infografiaPath = handleFileUpload('infografia', 'ProductosCatalogo/', 'infografia_');

    if ($id) {
        // Actualizar registro existente
        $queryStr = "UPDATE productos_catalogo SET ";
        $params = [];

        // Construcción dinámica de la consulta
        $fieldsToUpdate = [
            'activo' => $activo,
            'nombre' => $nombre,
            'descripcion' => $descripcion,
            'categoria' => $categoria,
            'sku' => $sku,
            'link_amazon' => $link_amazon,
            'link_ml' => $link_ml,
            'imagen_complementaria' => $imagen_complementariaPath,
            'imagen_principal' => $imagen_principalPath,
            'descripcion_complementaria' => $descripcion_complementaria,
            'meta_tags' => $meta_tags,
            'titulo_complementario' => $titulo_complementario,
            'infografia' => $infografiaPath,
            'idDescargable' => $idDescargable,
            'labelDescargable' => $labelDescargable,
            'descargableCategoria' => $descargableCategoria,
            'video' => $video,
        ];

        foreach ($fieldsToUpdate as $field => $value) {
            if ($value !== null) {
                $queryStr .= "$field = :$field, ";
                $params[":$field"] = $value;
            }
        }

        $queryStr = rtrim($queryStr, ", ");
        $queryStr .= " WHERE id = :id";
        $params[':id'] = $id;

        $query = $db->prepare($queryStr);
        foreach ($params as $key => &$val) {
            $query->bindParam($key, $val);
        }
    } else {
        // Insertar nuevo registro
        $queryStr = "INSERT INTO productos_catalogo (activo, nombre, descripcion, categoria, sku, link_amazon, link_ml, imagen_complementaria, imagen_principal, descripcion_complementaria, meta_tags, titulo_complementario, infografia, idDescargable, labelDescargable, descargableCategoria, video) 
        VALUES (:activo, :nombre, :descripcion, :categoria, :sku, :link_amazon, :link_ml, :imagen_complementaria, :imagen_principal, :descripcion_complementaria, :meta_tags, :titulo_complementario, :infografia, :idDescargable, :labelDescargable, :descargableCategoria, :video)";
        $params = [
            ':activo' => $activo,
            ':nombre' => $nombre,
            ':descripcion' => $descripcion,
            ':categoria' => $categoria,
            ':sku' => $sku,
            ':link_amazon' => $link_amazon,
            ':link_ml' => $link_ml,
            ':imagen_complementaria' => $imagen_complementariaPath,
            ':imagen_principal' => $imagen_principalPath,
            ':descripcion_complementaria' => $descripcion_complementaria,
            ':meta_tags' => $meta_tags,
            ':titulo_complementario' => $titulo_complementario,
            ':infografia' => $infografiaPath,
            ':idDescargable' => $idDescargable,
            ':labelDescargable' => $labelDescargable,
            ':descargableCategoria' => $descargableCategoria,
            ':video' => $video,
        ];

        $query = $db->prepare($queryStr);
        foreach ($params as $key => &$val) {
            $query->bindParam($key, $val);
        }
    }

    if ($query->execute()) {
        $productoId = $id ?: $db->lastInsertId();

        // Guardar imágenes
        if (isset($_POST['productos_imagenes']) && !empty($_POST['productos_imagenes'])) {
            $imagenes = is_string($_POST['productos_imagenes']) ? json_decode($_POST['productos_imagenes'], true) : $_POST['productos_imagenes'];
            saveImages($productoId, $imagenes, 'productos_imagenes');
        }

        // Guardar imágenes pequeñas
        if (isset($_POST['productos_imagenes_pequenas']) && !empty($_POST['productos_imagenes_pequenas'])) {
            $imagenes_pequenas = is_string($_POST['productos_imagenes_pequenas']) ? json_decode($_POST['productos_imagenes_pequenas'], true) : $_POST['productos_imagenes_pequenas'];
            saveImages($productoId, $imagenes_pequenas, 'productos_imagenes_pequenas');
        }

        eliminarImagenes($imagenesEliminadas,   'productos_imagenes');
        eliminarImagenes($imagenesPequenasEliminadas, 'productos_imagenes_pequenas');	

        echo json_encode(["success" => true, "message" => "Datos guardados correctamente."]);
    } else {
        throw new Exception("Error al guardar los datos.");
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => $e->getMessage()]);
}

function eliminarImagenes($imagenesIds, $tabla)
{
    global $db;

    if (!empty($imagenesIds)) {
        // Crear placeholders para la consulta SELECT
        $placeholdersSelect = implode(',', array_fill(0, count($imagenesIds), '?'));

        // Obtener rutas de imágenes para eliminarlas del servidor
        $query = $db->prepare("SELECT archivo FROM $tabla WHERE id IN ($placeholdersSelect)");
        $query->execute($imagenesIds);
        $imagenes = $query->fetchAll(PDO::FETCH_COLUMN);

        // Eliminar archivos del servidor
        foreach ($imagenes as $imagen) {
            $rutaArchivo = "ProductosCatalogo/" . basename($imagen);
            if (file_exists($rutaArchivo)) {
                unlink($rutaArchivo);
            }
        }

        // Crear placeholders para la consulta DELETE
        $placeholdersDelete = implode(',', array_fill(0, count($imagenesIds), '?'));
        
        // Eliminar registros de la base de datos
        $query = $db->prepare("DELETE FROM $tabla WHERE id IN ($placeholdersDelete)");
        $query->execute($imagenesIds);
    }
}


function handleFileUpload($inputName, $uploadDir, $prefix)
{

   /* var_dump($_FILES);

    $newFileName = uniqid('', true) . "." . pathinfo($_FILES[$inputName]['name'], PATHINFO_EXTENSION);
*/
    // Definir la ruta completa
    $baseDir = realpath(__DIR__ . '/../') . '/images/';
    var_dump("test");
    var_dump($uploadDir);
    var_dump($_FILES);

    if ($baseDir === false) {
        throw new Exception("No se pudo resolver el path base para /images/");
    }

    // Ruta final completa para guardar archivos (física)
    $fullUploadDir = $baseDir . $uploadDir;
    $fullUploadDir = rtrim(str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $fullUploadDir), DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;

    // Asegurar existencia del directorio
    if (!is_dir($fullUploadDir)) {
        if (!mkdir($fullUploadDir, 0777, true)) {
            throw new Exception("Error al crear el directorio: $fullUploadDir");
        }
    }

    // Validar archivo recibido
    if (isset($_FILES[$inputName]) && $_FILES[$inputName]['error'] === UPLOAD_ERR_OK) {
        $extension = pathinfo($_FILES[$inputName]['name'], PATHINFO_EXTENSION);
        $fileName = uniqid($prefix, true) . '.' . $extension;

        // Ruta lógica para BD
        $filePath = $uploadDir . $fileName;

        // Ruta física completa
        $uploadPath = $fullUploadDir . $fileName;

        // Mover archivo
        if (move_uploaded_file($_FILES[$inputName]['tmp_name'], $uploadPath)) {
            return $filePath;
        } else {
            throw new Exception("Error al mover el archivo a: $uploadPath");
        }
    }

    return null;
}

function saveImages($productoId, $imagenes, $tableName)
{
    global $db;
    $query = $db->prepare("DELETE FROM $tableName WHERE producto_id = :producto_id");
    $query->bindParam(':producto_id', $productoId, PDO::PARAM_INT);
    $query->execute();


    foreach ($imagenes as $index => $imagen) {
        $titulo = $imagen['titulo'];
        $descripcion = $imagen['descripcion'];
        $orden = $imagen['orden']  ?? 0;
        var_dump("imagen_$tableName" . "_$index" . "_archivo");
        var_dump("$tableName", "_$index" , "_archivo");

        $archivo = isset($_FILES["imagen_$tableName" . "_$index" . "_archivo"]) && $_FILES["imagen_$tableName" . "_$index" . "_archivo"]['error'] === UPLOAD_ERR_OK
            ? handleFileUpload("imagen_$tableName" . "_$index" . "_archivo", "ProductosCatalogo/", "imagen_")
            : (isset($_POST["imagen_$tableName" . "_$index" . "_imagen_old"]) ? $_POST["imagen_$tableName" . "_$index" . "_imagen_old"] : null);

        if ($archivo !== null) {
            $queryStr = "INSERT INTO $tableName (producto_id, titulo, descripcion, orden, archivo) VALUES (:producto_id, :titulo, :descripcion, :orden, :archivo)";
            $params = [
                ':producto_id' => $productoId,
                ':titulo' => $titulo,
                ':descripcion' => $descripcion,
                ':orden' => $orden,
                ':archivo' => $archivo,
            ];
        
            $query = $db->prepare($queryStr);
            foreach ($params as $key => &$val) {
                $query->bindParam($key, $val);
            }
            $query->execute();
        }
        /*$queryStr = "INSERT INTO $tableName (producto_id, titulo, descripcion, archivo) VALUES (:producto_id, :titulo, :descripcion, :archivo)";
        $params = [
            ':producto_id' => $productoId ?? null,
            ':titulo' => $titulo ?? null,
            ':descripcion' => $descripcion ?? null,
            ':archivo' => $archivo ?? null,
        ];

        $query = $db->prepare($queryStr);
        foreach ($params as $key => &$val) {
            $query->bindParam($key, $val);
        }
        $query->execute();*/
    }
}
