<?php
include '../conection/database.php';

$database = new Database();
$db = $database->getConnection();

// Obtener el parámetro de categoría si existe
$categoria = isset($_GET['categoria']) ? $_GET['categoria'] : null;

// Preparar la consulta base
$sql = "SELECT * FROM productos_catalogo";

// Si hay categoría, agregar el filtro
if ($categoria) {
    $sql .= " WHERE categoria = :categoria ORDER BY created_at DESC LIMIT 10";
}


$query = $db->prepare($sql);

// Si hay categoría, vincular el parámetro
if ($categoria) {
    $query->bindParam(':categoria', $categoria);
}

try {
    // Ejecutar la consulta
    $query->execute();
    $result = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($result) {
        echo json_encode(["success" => true, "productos" => $result]);
    } else {
        echo json_encode(["success" => false, "message" => "No se encontraron registros."]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Error al acceder a la base de datos: " . $e->getMessage()]);
}
