<?php

include '../conection/database.php';

$database = new Database();
$db = $database->getConnection();
$id = isset($_GET['id']) ? intval($_GET['id']) : null;
$tipo = isset($_GET['tipo']) ? $_GET['tipo'] : null;

if ($id === null) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "ID de producto no proporcionado."]);
    exit;
}

if ($tipo === null) {
    http_response_code(400);
    echo json_encode(["success" => false, "message" => "Tipo de acción no proporcionado."]);
    exit;
}

try {
    if ($tipo === 'Visita') {
        // Incrementar el contador de visitas (manejando NULL)
        $updateVisitas = $db->prepare("UPDATE productos_catalogo SET visitas = COALESCE(visitas, 0) + 1 WHERE id = :id");
        $updateVisitas->bindParam(':id', $id, PDO::PARAM_INT);
        $updateVisitas->execute();
        echo json_encode(["success" => true, "message" => "Visita registrada correctamente."]);
    } else {
        echo json_encode(["success" => true, "message" => "No se requiere actualización de visitas."]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["success" => false, "message" => "Error en el servidor: " . $e->getMessage()]);
}
