<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];


// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {

    case 'POST':
        handlePOST($pdo);
        break;



    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handlePOST($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $user = $input['user'] ?? null;

    if ($user) {
        $activo = $user['activo'] ?? null;
        $uid = $user['uid'] ?? null;
        $email = $user['email'] ?? null;
        $password = $user['password'] ?? null; 
        $nombre = $user['nombre'] ?? null;
        $apellidoPaterno = $user['apellidoPaterno'] ?? null;
        $apellidoMaterno = $user['apellidoMaterno'] ?? null;
        $interes_otro = $user['interes_otro'] ?? null;
        $interes = $user['interes'] ?? null;
        $dia = $user['dia'] ?? null;
        $mes = $user['mes'] ?? null;
        $anio = $user['anio'] ?? null;
        $sexo = $user['sexo'] ?? null;
        $rol = $user['rol'] ?? null;
        $fechaRegistro = $user['fechaRegistro'] ?? null;

        try {
            // Usa $pdo en lugar de $db
            $stmt = $pdo->prepare('INSERT INTO usuarios (id, apellidoPaterno, fechaRegistro, interes_otro, nombre, rol, apellidoMaterno, uid, mes, sexo, dia, email, anio, activo, interes, password) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
            $stmt->execute([
                $uid,
                $apellidoPaterno,
                $fechaRegistro,
                $interes_otro,
                $nombre,
                $rol,
                $apellidoMaterno,
                $uid,
                $mes,
                $sexo,
                $dia,
                $email,
                $anio,
                $activo,
                $interes,
                $password
            ]);

            http_response_code(201);
            echo json_encode(['message' => 'Usuario creado']);
        } catch (Exception $e) {
            error_log('Error fetching data: ' . $e->getMessage());
            http_response_code(500);
            echo json_encode(['error' => 'Failed to fetch data']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid input']);
    }
}

function encrypt($string, $shift) {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $result .= chr(ord($string[$i]) + $shift);
    }
    return $result;
}

function decrypt($string, $shift) {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++) {
        $result .= chr(ord($string[$i]) - $shift);
    }
    return $result;
}

?>
