<?php
// api.php

header("Content-Type: application/json; charset=UTF-8");

// Incluir la conexión a la base de datos
include 'conection/db.php';

// Obtener el método de la solicitud
$method = $_SERVER['REQUEST_METHOD'];

// Obtener el parámetro 'id' si está presente en la URL
// Por ejemplo: api.php?id=1
$id = isset($_GET['id']) ? $_GET['id'] : null;

// Manejar solicitudes OPTIONS para CORS preflight
if ($method == 'OPTIONS') {
    exit(0);
} 

switch ($method) {
    case 'GET':
        handleGET($pdo);
        break;

    case 'POST':
        handlePOST($pdo);
        break;

    case 'PUT':
        handlePUT($pdo, $id);
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Metodo no permitido"]);
        break;
}


function handlePOST($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $email = $input['email'] ?? null;

  try {
      if ($email) {
          // Obtener un solo registro
          $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE email = :email");
          $stmt->bindParam(':email', $email, PDO::PARAM_STR);
          $stmt->execute();
          $data = $stmt->fetch(PDO::FETCH_ASSOC);
          
          if ($data) {
                if (!empty($data['password'])) {
                    echo json_encode(["status" => "success", "message" => "Usuario existente con contraseña"]);
                } else {
                    echo json_encode(["status" => "warning", "message" => "Usuario existente sin contraseña"]);
                }
            } else {
                http_response_code(404);
                echo json_encode(["status" => "error", "message" => "Registro no encontrado"]);
            }
        } 
  } catch (PDOException $e) {
      http_response_code(500);
      echo json_encode(["status" => "error", "message" => "Error al obtener los datos: " . $e->getMessage()]);
  }
}


/*function handlePOST($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $email = $input['email'] ?? null;
    $password = $input['password'] ?? null;
    $tipo = $input['tipo'] ?? null;

    try {
        if ($tipo === "actualizar") {
            if (!$password && !$email) {
                http_response_code(401);
                echo json_encode(['error' => 'Error Datos']);
                return;
            }

            $stmt = $pdo->prepare('UPDATE usuarios SET password = ? WHERE email = ?');
            $stmt->execute([$password, $email]);

            if ($stmt->rowCount() === 0) {
                http_response_code(404);
                echo json_encode(['message' => 'Registro no encontrado']);
                return;
            }

            echo json_encode(['message' => 'update']);
            return;
        } else {
            $stmt = $pdo->prepare('SELECT * FROM usuarios WHERE email = ?');
            $stmt->execute([$email]);
            $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$usuario) {
                http_response_code(401);
                echo json_encode(['error' => 'Invalido email o password']);
                return;
            }

            if (!$usuario['password']) {
                http_response_code(401);
                echo json_encode(['error' => 'No registrado']);
                return;
            }

            if ($password !== $usuario['password']) {
                http_response_code(401);
                echo json_encode(['error' => 'No valido']);
                return;
            }

            $stmt_descargables = $pdo->prepare('SELECT * FROM usuarios_descargables WHERE id_usuario = ?');
            $stmt_descargables->execute([$usuario["id"]]);
            $descargables = $stmt_descargables->fetchAll(PDO::FETCH_ASSOC);

            $stmt_videos = $pdo->prepare('SELECT * FROM usuarios_videos WHERE id_usuario = ?');
            $stmt_videos->execute([$usuario["id"]]);
            $videos = $stmt_videos->fetchAll(PDO::FETCH_ASSOC);

            $stmt_blogs = $pdo->prepare('SELECT * FROM usuarios_blogs WHERE id_usuario = ?');
            $stmt_blogs->execute([$usuario["id"]]);
            $blogs = $stmt_blogs->fetchAll(PDO::FETCH_ASSOC); 

            echo json_encode([
                'usuario' => $usuario,
                'blogs' => $blogs,
                'videos' => $videos,
                'descargables' => $descargables,
            ]);
            return;
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Failed to fetch data']);
    }
}*/

function handlePUT($pdo) {
    $input = json_decode(file_get_contents("php://input"), true);
    $id_u = $input['id'] ?? null;
    $data = $input['data'] ?? null;

    $apellidoPaterno = $data['apellidoPaterno'] ?? null;
    $apellidoMaterno = $data['apellidoMaterno'] ?? null;
    $dia = $data['dia'] ?? null;
    $mes = $data['mes'] ?? null;
    $anio = $data['anio'] ?? null;
    $interes = $data['interes'] ?? null;
    $interes_otro = $data['interes_otro'] ?? "";
    $email = $data['email'] ?? null;

    if (!$id_u || !$apellidoPaterno || !$apellidoMaterno) {
        http_response_code(400); // Solicitud incorrecta
        echo json_encode(['error' => 'Datos incompletos']);
        return;
    }


    try {
        // Actualizar el registro en la base de datos
        $stmt = $pdo->prepare('UPDATE usuarios SET apellidoPaterno = ?, apellidoMaterno = ?, dia = ?, mes = ?, anio = ?, interes = ?, interes_otro = ?, email = ? WHERE id = ?');
        $stmt->execute([$apellidoPaterno, $apellidoMaterno, $dia, $mes, $anio, $interes, $interes_otro, $email, $id_u]);

        if ($stmt->rowCount() === 0) {
            http_response_code(404); // No se encontró el registro
            echo json_encode(['message' => 'Usuario no encontrado o no se realizaron cambios']);
        } else {
            echo json_encode(['message' => 'Usuario actualizado correctamente']);
        }
    } catch (Exception $e) {
        http_response_code(500); // Error del servidor
        echo json_encode(['error' => 'Error al actualizar el usuario']);
    }

}
function convertBooleans($item) {
    foreach ($item as $key => $value) {
        if ($value === '1' || $value === 1) {
            $item[$key] = true;
        } elseif ($value === '0' || $value === 0) {
            $item[$key] = false;
        }
    }
    return $item;
}
?>
